import '../dashboard_nav_edit_link/dashboard_nav_edit_link';
import './dashboard_switcher.less';
import { KibiNavBarHelperFactory } from 'ui/kibi/directives/kibi_nav_bar_helper';
import { FilterBarQueryFilterProvider } from 'ui/filter_bar/query_filter';
import template from './dashboard_switcher.html';
import { uiModules } from 'ui/modules';
import uiRoutes from 'ui/routes';
import _ from 'lodash';
import { MissingDashboardError } from 'ui/kibi/errors/missing_dashboard_error';
import { DashboardConstants } from 'plugins/kibana/dashboard/dashboard_constants';
import { onDashboardPage } from 'ui/kibi/utils/on_page';
import chrome from 'ui/chrome';
import { SpinnerStatus } from 'ui/kibi/spinners/spinner_status';

uiModules
  .get('kibana')
// Note: mind that this directive gets destroyed on every dashboard switch
  .directive('dashboardSwitcher', function (dashboardGroups, dashboardsNavState, createNotifier, kibiState,
    Private, $rootScope, globalNavState, kbnUrl, $timeout) {
    const kibiNavBarHelper = Private(KibiNavBarHelperFactory);
    const queryFilter = Private(FilterBarQueryFilterProvider);
    let notify = createNotifier({
      location: 'Dashboard Navigation Bar'
    });

    return {
      restrict: 'E',
      scope: {
        filter: '=',
        isSaving: '='
      },
      template,
      controller($scope, $element) {
        $scope.updateSavingState = value => {
          $scope.isSaving = value;
          if ($scope.isSaving) {
            $timeout(() => {
              $scope.isSaving = false;
            }, 5000);
          }
        };

        $scope.persistCollapsedGroupState = () => {
          const collapsedGroups = [];
          $scope.groups.forEach(group => {
            if (!group.virtual && group.collapsed) {
              collapsedGroups.push(group.id);
            }
          });
          dashboardsNavState.setCollapsedGroups(collapsedGroups);
        };

        $scope.restoreCollapsedGroupState = () => {
          const collapsedGroups = dashboardsNavState.collapsedGroups();
          $scope.groups.forEach(group => {
            if (_.indexOf(collapsedGroups, group.id) >= 0) {
              group.collapsed = true;
            }
          });
        };

        // Don't try to make this shorter (by removing the wrapper)
        // or the 'this' used in the kibi state will be wrong, producing errors.
        $scope.$watch(() => {
          return kibiState.getCurrentDashboardId();
        }, id => {
          if (id) {
            dashboardGroups.getGroups().forEach(group => {
              group.dashboards.forEach(dash => dash.$$highlight = false);
            });
            const group = dashboardGroups.getGroup(id);
            if (group) {
              group.collapsed = false;
              $scope.persistCollapsedGroupState();
              const dashboardIds = _(group.dashboards).filter(d => d.count === SpinnerStatus.UNDEFINED).map('id').value();
              if (dashboardIds.length > 0 && dashboardGroups.isInitialized) {
                dashboardGroups.updateMetadataOfDashboardIds(dashboardIds);
              }
            }
          }
        });

        $scope.groups = dashboardGroups.getGroups();
        $scope.$watchCollection(() => dashboardGroups.getGroups(), function (groups) {
          if (groups) {
            $scope.persistCollapsedGroupState();
            dashboardGroups.setActiveGroupFromUrl();
            $scope.groups = dashboardGroups.getGroups();
            $scope.restoreCollapsedGroupState();
            $scope.$emit('kibi:dashboardGroups:updated');
          }
        });

        $scope.isGroupEditorOpen = dashboardsNavState.isGroupEditorOpen();
        $scope.$watch(dashboardsNavState.isGroupEditorOpen, isGroupEditorOpen => {
          $scope.isGroupEditorOpen = isGroupEditorOpen;
        });

        const computeDashboardsGroups = (reason, action = '', forceUpdate = false) => {
          if (!forceUpdate) {
            $scope.persistCollapsedGroupState();
          }
          const groupsPromise = dashboardGroups.computeGroups(reason);
          const metadataPromise = groupsPromise.then(groups => {
            $scope.groups = _.cloneDeep(groups);
            if (!forceUpdate) {
              $scope.restoreCollapsedGroupState();
            }
            const dashboardIds = _($scope.groups)
              .filter(g => (forceUpdate || !g.collapsed) || g.virtual)
              .map('dashboards')
              .flatten()
              .map('id')
              .value();
            return dashboardGroups.updateMetadataOfDashboardIds(dashboardIds);
          });

          return Promise.all([ groupsPromise, metadataPromise ])
            .then(() => {
              $timeout(() => {
                if (action === 'selectDashboard') {
                  kbnUrl.change(DashboardConstants.LANDING_PAGE_PATH);
                }
              }, 1000);
            })
            .catch((err) => {
              // ignore all missing dashboard errors as user might not have permissions to see them
              if (!(err instanceof MissingDashboardError)) {
                notify.error(err);
              }
            });
        };

        const kibiDashboardChangedHandler = function (event, dashId) {
          computeDashboardsGroups('Dashboard changed')
            .then(function () {
              kibiNavBarHelper.updateAllCounts([ dashId ], 'kibi:dashboard:changed event');
            });
        };

        // rerender tabs if any dashboard got saved
        const removeDashboardChangedHandlerOff = $rootScope.$on('kibi:dashboard:changed', kibiDashboardChangedHandler);

        $scope.$on('kibi:dashboardgroup:changed', () => {
          computeDashboardsGroups('Dashboard group changed');
        });

        $scope.$on('kibi:dashboardgroup:deletedashboard', () => {
        // kibi: we should remove lastSubUrl from dashboard link
        // otherwise if we click some other page and then click dashboard again
        // it will try to go deleted dashboard
          const link = chrome.getNavLinks().filter(link => link.id === 'kibana:dashboard')[0];
          link.lastSubUrl = '';
          computeDashboardsGroups('Dashboard group changed')
            .then(() => {
              if (onDashboardPage()) {
                kbnUrl.change(DashboardConstants.LANDING_PAGE_PATH);
              }
            });
        });

        // this controller will receive x event calls one per dashboard, so, we need to debounce the calls.
        $scope.refreshCount = _.debounce(() => {
          computeDashboardsGroups('Refresh counts', 'refresh', true);
        }, 5000, { leading: true, trailing: false });

        $scope.$on('kibi:dashboardgroup:reloadcounts', () => {
          $scope.refreshCount();
        });

        $scope.$listen(queryFilter, 'update', function () {
          const currentDashboardId = kibiState.getCurrentDashboardId();
          if (currentDashboardId) {
            kibiNavBarHelper.updateAllCounts([currentDashboardId], 'filters change');
          }
        });

        $scope.$on('$destroy', function () {
          kibiNavBarHelper.destroy();
          removeDashboardChangedHandlerOff();
          notify = null; // this allow to completely garbage collect the object from memory
        });
      }
    };
  })
  .filter('kibiGroupFilter', () => {
    return (input, filter) => {
      if (!filter) {
        return input;
      }
      const filtered = [];
      const exp = new RegExp(filter, 'i');
      input.forEach(group => {
        if (!filter || !group.virtual || (filter && group.virtual && group.title.search(exp) !== -1)) {
          filtered.push(group);
        }
      });
      return filtered;
    };
  });
