'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _joi = require('joi');

var _joi2 = _interopRequireDefault(_joi);

var _model = require('../model');

var _model2 = _interopRequireDefault(_model);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Model for dashboard objects.
 */
class DashboardModel extends _model2.default {
  constructor(server) {
    const schema = _joi2.default.object().keys({
      title: _joi2.default.string(),
      hits: _joi2.default.number().integer(),
      description: _joi2.default.string(),
      panelsJSON: _joi2.default.string(),
      optionsJSON: _joi2.default.string(),
      uiStateJSON: _joi2.default.string(),
      version: _joi2.default.number().integer(),
      timeRestore: _joi2.default.boolean(),
      timeMode: _joi2.default.string(),
      timeTo: _joi2.default.string(),
      timeFrom: _joi2.default.string(),
      refreshInterval: _joi2.default.object().keys({
        display: _joi2.default.string(),
        pause: _joi2.default.boolean(),
        value: _joi2.default.number(),
        section: _joi2.default.number()
      }),
      priority: _joi2.default.number(),
      kibanaSavedObjectMeta: _joi2.default.object().keys({
        searchSourceJSON: _joi2.default.string()
      }),
      coatJSON: _joi2.default.string()
    });

    super(server, 'dashboard', schema, 'Dashboard');
  }
}
exports.default = DashboardModel;
module.exports = exports['default'];
