'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _joi = require('joi');

var _joi2 = _interopRequireDefault(_joi);

var _model = require('../model');

var _model2 = _interopRequireDefault(_model);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Model for dashboardgroup objects.
 */
class DashboardGroupModel extends _model2.default {
  constructor(server) {
    const schema = _joi2.default.object().keys({
      title: _joi2.default.string(),
      description: _joi2.default.string(),
      dashboards: _joi2.default.object(),
      priority: _joi2.default.number(),
      iconCss: _joi2.default.string(),
      iconUrl: _joi2.default.string(),
      hide: _joi2.default.boolean(),
      version: _joi2.default.number().integer(),
      kibanaSavedObjectMeta: _joi2.default.object().keys({
        searchSourceJSON: _joi2.default.string()
      })
    });

    super(server, 'dashboardgroup', schema, 'Dashboard group');
  }
}
exports.default = DashboardGroupModel;
module.exports = exports['default'];
