'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _joi = require('joi');

var _joi2 = _interopRequireDefault(_joi);

var _model = require('../model');

var _model2 = _interopRequireDefault(_model);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Model for template objects.
 */
class TemplateModel extends _model2.default {
  constructor(server) {

    const schema = _joi2.default.object().keys({
      title: _joi2.default.string(),
      description: _joi2.default.string().default(null),
      templateSource: _joi2.default.string(),
      templateEngine: _joi2.default.string(),
      version: _joi2.default.number().integer(),
      kibanaSavedObjectMeta: _joi2.default.object().keys({
        searchSourceJSON: _joi2.default.string()
      })
    });

    super(server, 'template', schema, 'Template');
  }
}
exports.default = TemplateModel;
module.exports = exports['default'];
