'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _model = require('../model');

var _model2 = _interopRequireDefault(_model);

var _joi = require('joi');

var _joi2 = _interopRequireDefault(_joi);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Model for shared URL objects.
 */
class URLModel extends _model2.default {
  constructor(server) {

    const schema = _joi2.default.object().keys({
      accessCount: _joi2.default.number(),
      accessDate: _joi2.default.date(),
      createDate: _joi2.default.date(),
      url: _joi2.default.string(),
      sirenSession: _joi2.default.any()
    });

    super(server, 'url', schema, 'Shared link');
  }
}
exports.default = URLModel;
module.exports = exports['default'];
