'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _base = require('./base');

var _base2 = _interopRequireDefault(_base);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Thrown when authentication is required.
 */
class AuthenticationError extends _base2.default {
  /**
   * Creates a new AuthenticationError.
   *
   * @param {string} message - The error message.
   * @param {Error} inner - An optional error that caused the AuthenticationError.
   */
  constructor(message, inner) {
    super(message, inner);
    this.name = 'AuthenticationError';
    this.status = 401;
    this.statusCode = 401;
  }
}
exports.default = AuthenticationError;
module.exports = exports['default'];
