'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _base = require('./base');

var _base2 = _interopRequireDefault(_base);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Thrown when saving an object would generate a conflict.
 */
class ConflictError extends _base2.default {
  /**
   * Creates a new ConflictError.
   *
   * @param {string} message - The error message.
   * @param {Error} inner - An optional error that caused the ConflictError.
   */
  constructor(message, inner) {
    super(message, inner);
    this.name = 'ConflictError';
  }
}
exports.default = ConflictError;
module.exports = exports['default'];
