'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isVersionGreaterThanOrEqual = isVersionGreaterThanOrEqual;

var _semver = require('semver');

var _semver2 = _interopRequireDefault(_semver);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function isVersionGreaterThanOrEqual(actual, test) {
  const a = {
    major: _semver2.default.major(actual),
    minor: _semver2.default.minor(actual),
    patch: _semver2.default.patch(actual),
    prerelease: _semver2.default.prerelease(actual)
  };

  const t = {
    major: _semver2.default.major(test),
    minor: _semver2.default.minor(test),
    patch: _semver2.default.patch(test),
    prerelease: _semver2.default.prerelease(test)
  };

  if (a.major === t.major && a.minor === t.minor && a.patch === t.patch && a.prerelease >= t.prerelease) {
    return true;
  }
  return false;
}
