'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addSessionPingRoute = addSessionPingRoute;

var _boom = require('boom');

var _boom2 = _interopRequireDefault(_boom);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function addSessionPingRoute(server) {
  const config = server.config();
  const { callWithInternalUser } = server.plugins.elasticsearch.getCluster('admin');
  const sirenIndex = server.config().get('kibana.index');

  server.route({
    method: 'GET',
    path: '/session/ping',
    handler: function (req, reply) {
      const headers = {};
      const header = server.plugins && server.plugins.siren_federate && server.plugins.siren_federate.federateClient ? server.plugins.siren_federate.federateClient.getFederateSessionHeader(req) : null;
      if (header) {
        headers[header.name] = header.value;
      }
      callWithInternalUser('siren_search', {
        index: sirenIndex,
        size: 0,
        headers
      }).then(resp => {
        reply({ status: 'ok' });
      }).catch(err => {
        if (err.body && err.body.error && err.body.error.type === 'license_exception') {
          reply(_boom2.default.wrap(new Error(err.body.error.reason), 404));
        } else {
          reply(_boom2.default.wrap(err, 404));
        }
      });
    }
  });
}
