import $ from 'jquery';
import { set } from 'lodash';

export function initChromeXsrfApi(chrome, internals) {

  chrome.getXsrfToken = function () {
    // kibi: use investigate version
    return internals.kibiVersion;
  };

  $.ajaxPrefilter(function ({ kbnXsrfToken = true }, originalOptions, jqXHR) {
    if (kbnXsrfToken) {
      // kibi: use investigate version
      jqXHR.setRequestHeader('kbn-version', internals.kibiVersion);
    }
  });

  chrome.$setupXsrfRequestInterceptor = function ($httpProvider) {
    $httpProvider.interceptors.push(function () {
      return {
        request: function (opts) {
          const { kbnXsrfToken = true } = opts;
          if (kbnXsrfToken) {
            // kibi: use investigate version
            set(opts, ['headers', 'kbn-version'], internals.kibiVersion);
          }
          return opts;
        }
      };
    });
  };
}
