import _ from 'lodash';
// kibi: imports
import { getAlternativeSortingField } from 'ui/kibi/components/courier/data_source/get_alternative_sorting_field';
// kibi: end

/**
 * Take a sorting array and make it into an object
 * @param {array} 2 item array [fieldToSort, directionToSort]
 * @param {object} indexPattern used for determining default sort
 * @returns {object} a sort object suitable for returning to elasticsearch
 */
export function getSort(sort, indexPattern) {
  const sortObj = {};
  let field;
  let direction;

  function isSortable(field) {
    return (indexPattern.fields.byName[field] && indexPattern.fields.byName[field].sortable);
  }

  // kibi: check if field has an alternative sorting field
  if (_.isArray(sort) && sort.length === 2 && !isSortable(sort[0])) {
    // kibi: check if there is a valid alternative sorting field if the column is not sortable
    const indexField = indexPattern.fields.byName ? indexPattern.fields.byName[sort[0]] : null;
    if (indexField) {
      const alternativeSortingField = getAlternativeSortingField(indexPattern, indexField);
      if (alternativeSortingField) {
        field = alternativeSortingField.name;
        direction = sort[1];
      }
    }
  } else if (_.isArray(sort) && sort.length === 2 && isSortable(sort[0])) {
    // At some point we need to refact the sorting logic, this array sucks. Yes.
    field = sort[0];
    direction = sort[1];
  }

  if (!field && indexPattern.timeFieldName && isSortable(indexPattern.timeFieldName)) {
    field = indexPattern.timeFieldName;
    direction = 'desc';
  }
  // kibi: end

  if (field) {
    sortObj[field] = direction;
  } else {
    sortObj._score = 'desc';
  }

  return sortObj;
}

getSort.array = function (sort, indexPattern) {
  return _(getSort(sort, indexPattern)).pairs().pop();
};

