function fieldsWithoutMetaFields(indexPattern) {
  if (!indexPattern.metaFields) {
    return indexPattern.fields;
  }
  const fields = [];
  const metaFields = indexPattern.metaFields;
  indexPattern.fields.forEach((field) => {
    if (metaFields.indexOf(field.name) === -1) {
      fields.push(field);
    };
  });
  return fields;
};

export function GetFieldsFromAllIndexPatternsProvider(indexPatterns) {

  return function getFieldsFromAllIndexPatterns() {
    return indexPatterns.getIds()
      .then(ids => {
        const promises = [];
        ids.forEach((id) => {
          promises.push(indexPatterns.get(id));
        });
        return Promise.all(promises)
          .then(allIndexPatterns => {
            let fields = [];
            allIndexPatterns.forEach((indexPattern) => {
              fields = fields.concat(fieldsWithoutMetaFields(indexPattern));
            });
            return fields;
          });
      });
  };
};
