import { FilterMetaPropertyIndexError, FilterMetaPropertyKeyError } from 'ui/errors';

export function FilterBarLibMapScriptProvider(Promise, courier) {
  return function (filter) {
    if (filter.script) {
      return courier
        .indexPatterns
        .get(filter.meta.index)
        .then(function (indexPattern) {
          const type = 'scripted';
          const key = filter.meta.field;
          // kibi: handle case where fields are not present (indexPattern no longer exists);
          if (!indexPattern.fields) {
            return Promise.reject(new FilterMetaPropertyIndexError(filter.meta.index));
          }
          // kibi: end
          const field = indexPattern.fields.byName[key];
          // kibi: handle case where the field is no longer present in the index-pattern
          if (!field) {
            return Promise.reject(new FilterMetaPropertyKeyError(key, filter.meta.index));
          }
          // kibi: end
          let value;
          if (filter.meta.formattedValue) {
            value = filter.meta.formattedValue;
          } else {
            value = filter.script.script.params.value;
            value = field.format.convert(value);
          }
          return { type, key, value };
        })
        .catch(err => {
          if (err instanceof FilterMetaPropertyKeyError || err instanceof FilterMetaPropertyIndexError) {
            return Promise.reject(err);
          }
          return Promise.reject(new FilterMetaPropertyIndexError(filter.meta.index));
        });
    }
    return Promise.reject(filter);
  };
}
