import 'angular-ui-select';
import { uiModules } from 'ui/modules';
import { getFieldOptions } from './lib/filter_editor_utils';
import template from './filter_field_select.html';
import '../directives/ui_select_focus_on';
import '../filters/sort_prefix_first';
import '../filters/escape_html';

const module = uiModules.get('kibana');
module.directive('filterFieldSelect', function () {
  return {
    restrict: 'E',
    template,
    scope: {
      indexPatterns: '=',
      field: '=',
      onSelect: '&'
    },
    link: function ($scope) {
      $scope.$watch('indexPatterns', indexPatterns => {
        $scope.fieldOptions = getFieldOptions(indexPatterns);
      });

      $scope.getFieldIndexPattern = field => {
        return field.indexPattern.title;
      };
    }
  };
});
