import { uiModules } from 'ui/modules';
import template from './filter_params_input_type.html';
import '../../directives/validate_date_math';
import '../../directives/validate_ip';
//kibi: added to support custom mapping validation
import 'ui/kibi/directives/siren_validate_custom_date_math';
//kibi: end

const module = uiModules.get('kibana');
module.directive('filterParamsInputType', function () {
  return {
    restrict: 'E',
    template,
    scope: {
      type: '=',
      field: '=',
      indexPattern: '=',
      placeholder: '@',
      value: '=',
      onChange: '&'
    },
    link: function (scope) {
      scope.boolOptions = [true, false];
      scope.setDefaultBool = () => {
        if (scope.value == null) {
          scope.value = scope.boolOptions[0];
          scope.onChange({
            value: scope.value
          });
        }
      };
    }
  };
});
