import _ from 'lodash';
import { Notifier } from 'ui/notify/notifier';
import { NoDefaultIndexPattern, SavedObjectNotFound } from 'ui/errors';

const notify = new Notifier({
  location: 'Index Patterns'
});

// kibi: imports
import { RootSearchSourceProvider } from 'ui/courier/data_source/_root_search_source';
// kibi: end

// kibi: kibiDefaultIndexPattern are added
module.exports = function loadDefaultIndexPattern(Private, $route, config, kibiDefaultIndexPattern) {

  const rootSearchSource = Private(RootSearchSourceProvider);
  const route = _.get($route, 'current.$$route');

  if (route.requireDefaultIndex) {
    const defaultId = config.get('defaultIndex');
    // kibi:
    // set the default indexPattern as it is required by the route
    // handle authorization errors
    notify.event('loading default index pattern');
    return kibiDefaultIndexPattern.getDefaultIndexPattern(defaultId)
      .then(indexPattern => {
        if (!indexPattern.id) {
          throw new NoDefaultIndexPattern();
        };
        rootSearchSource.getGlobalSource().set('index', indexPattern);
        notify.log('index pattern set to', indexPattern.id);
      })
      .catch(err => {
        if (err instanceof SavedObjectNotFound) {
          err.message = `Could not locate default index pattern. (id: ${err.savedObjectId}). ` +
        'Make sure the value set in Advanced Settings matches an existing index pattern.';
        }

        throw err; // kibi: rethrow it will be handled in 'afterWork'
      });
  }
};