import 'kibi-qtip2';
import $ from 'jquery';
import { uiModules } from 'ui/modules';
import './dash360_explenation.less';
import angular from 'angular';
import uuid from 'uuid';
import { VisProvider } from 'ui/vis/vis';
import { find } from 'lodash';

uiModules
  .get('kibana')
  .directive('dash360Explanation', function ($compile, SavedDashboard, Private, $document) {
    return {
      restrict: 'A',
      scope: {
        dash360Explanation: '=', // dash or vis object
        sirenData: '='
      },
      link: function (scope, $el, attrs) {
        const Vis = Private(VisProvider);

        let api;
        let mainSearchLabel;
        let $qtipElement;

        if (scope.dash360Explanation instanceof SavedDashboard) {
          const mainSearch = find(scope.sirenData.coat.items, item => item.d.isRoot === true);
          if (!mainSearch) {
            return;
          }
          mainSearchLabel = mainSearch.d.entity.label;
          scope.focusNodeId = mainSearch.id;
        } else if (scope.dash360Explanation instanceof Vis) {
          mainSearchLabel = scope.sirenData.coat.node.d.entity.label;
          scope.focusNodeId = scope.sirenData.coat.node.id;
        } else {
          throw new Error('dash360Explanation directive require either SavedDashboard or SavedVis to be passed in');
        }

        scope.id = uuid.v1();

        const prepareContent = () => {
          $qtipElement = angular.element(
            `<div style="width: 600px; height: 440px; display: none;">
              <div ng-cloak>
                <div class="title">How <b>${ mainSearchLabel }</b> search is connected on this dashboard</div>
                <siren-tree-read-only coat-items="sirenData.coat.items" focus-node-id="focusNodeId" siren-id="id"></siren-tree-read-only>
              </div>
            </div>`
          );

          // Note:
          // We have to append the content to the body
          // if not graph library will complain during compile that it can not find the element in the body
          const $body = $document.find('body').eq(0);
          $body.append($qtipElement);

          $compile($qtipElement)(scope);
          return $qtipElement;
        };

        const initQtip = () => {
          const options = {
            content: {
              text: prepareContent()
            },
            position: {
              my: 'top center',
              at: 'bottom center',
              target: $el,
              viewport: true
            },
            show: {
              delay: 250,
              event: 'mouseover'
            },
            hide: {
              fixed : true,
              delay: 0
            },
            style: {
              classes: 'dash360-qtip'
            }
          };

          $el.qtip(options);
          api = $el.qtip('api');
        };

        initQtip();

        scope.$on('$destroy', () => {
          if (api) {
            api.destroy(true);
          }
          if ($qtipElement) {
            const el = $qtipElement.get(0);
            const parent = $qtipElement.parent().get(0);
            if (parent) {
              parent.removeChild(el);
            }
            $qtipElement = null;
          }
        });
      }
    };
  });
