import { filter } from 'lodash';

export function pruneNotFoundItems(focusedTree) {
  return filter(focusedTree, item => {
    if (item.type === 'link' && item.d && item.d.rel && item.d.rel.notFound) {
      return false;
    } else if (item.type === 'node' && item.d && item.d.entity && item.d.entity.notFound) {
      return false;
    }
    return true;
  });
}