import { find, cloneDeep } from 'lodash';
import expect from 'expect.js';

export function compare(actualTree, expectedTree) {
  expect(actualTree.length).to.eql(expectedTree.length);
  for (const expectedNode of expectedTree) {
    const actualNode = find(actualTree, 'id', expectedNode.id);
    expect(actualNode).to.eql(expectedNode);
  }
}

export function compareTimeFilters(actualTree, expectedTree) {
  expect(actualTree.length).to.eql(expectedTree.length);
  for (const expectedNode of expectedTree) {
    const actualNode = find(actualTree, 'id', expectedNode.id);
    if (expectedNode.type === 'node') {
      const actualNodeFilters = actualNode.d.entity.filters;
      const expectedNodeFilters = expectedNode.d.entity.filters;

      if (expectedNodeFilters) {
        expect(actualNodeFilters.length).to.equal(expectedNodeFilters.length);
        expect(actualNodeFilters.length).to.equal(1);
        // ignore from to, check the timeField
        const keysA = Object.keys(actualNodeFilters[0].range);
        const keysB = Object.keys(expectedNodeFilters[0].range);
        expect(keysA).to.eql(keysB);
      } else {
        expect(actualNodeFilters).to.be(undefined);
      }
    } else {
      expect(actualNode).to.eql(expectedNode);
    }
  }
}

export function addFilters(node, filters) {
  const clone = cloneDeep(node);
  if (filters) {
    if (!clone.d) {
      clone.d = {};
    }
    if (!clone.d.entity) {
      clone.d.entity = {};
    }
    clone.d.entity.filters = filters;
  }
  return clone;
}

export function addDepth(node, depth) {
  const clone = cloneDeep(node);
  clone.depth = depth;
  return clone;
}
