import _ from 'lodash';
import {
  FilterIndexPatternNotFound,
  FilterMetaPropertyIndexError,
  FilterMetaPropertyKeyError
} from 'ui/errors';

const checkForMissingIndexPatterns = function (filter, courier, Promise) {
  const joinSeq = JSON.stringify(filter.join_sequence);
  const indexPatternIds = [];
  JSON.parse(joinSeq, (key, value) => {
    if (key === 'pattern' && indexPatternIds.indexOf(value) === -1) {
      indexPatternIds.push(value);
    }
  });
  if (indexPatternIds.length === 0) {
    return Promise.resolve();
  }
  const promises = indexPatternIds.map(function (id) {
    return courier.indexPatterns.get(id)
      .then(indexPattern => {
        if (!indexPattern.fields) {
          return Promise.reject(new FilterIndexPatternNotFound('pattern', id));
        }
      })
      .catch(err => {
        return Promise.reject(new FilterIndexPatternNotFound('pattern', id));
      });
  });
  return Promise.all(promises);
};

export function SirenJoinProvider(Promise, courier) {
  return function (filter) {
    if (filter.join_sequence) {
      let metaPromise = Promise.resolve();
      if (filter.meta && filter.meta.index) {
        metaPromise = courier
          .indexPatterns
          .get(filter.meta.index)
          .then(indexPattern => {
            if (!indexPattern.fields) {
              return Promise.reject(new FilterMetaPropertyIndexError(filter.meta.index));
            }
          });
      }
      return metaPromise
        .then(() => checkForMissingIndexPatterns(filter, courier, Promise))
        .then(() => {
          return { key: filter.meta.key, value: filter.meta.value };
        })
        .catch(err => {
          if (err instanceof FilterMetaPropertyIndexError || err instanceof FilterIndexPatternNotFound) {
            return Promise.reject(err);
          }
          return Promise.reject(new FilterMetaPropertyIndexError(filter.meta.index));
        });
    }
    return Promise.reject(filter);
  };
};
