import { isPlainObject } from 'lodash';

// We wrap cache library in simple helper
// in case we would like to change the underlying implementation in future (e.g. use localStorage)
// it will be easy to do it here
class CacheHelper {
  constructor() {
    // we will store values in memory
    this.cache = {};
  }

  set = (key, value) => {
    this.cache[key] = value;
  }

  has = key => {
    if (this.cache[key] !== undefined) {
      return true;
    }
    return false;
  }

  get = key => {
    if (this.cache[key]) {
      if (isPlainObject(this.cache[key])) {
        // TODO: #10287 Object.freeze this after 10.3.0 release!
        return this.cache[key];
      } else {
        return this.cache[key];
      }
    }
    return null;
  };

  invalidate = () => {
    this.cache = {};
  };
}

export function CacheProvider($rootScope) {
  const cacheHelperInstance = new CacheHelper();
  // invalidate the cache on route change
  $rootScope.$on('$routeChangeStart', function () {
    cacheHelperInstance.invalidate();
  });

  return cacheHelperInstance;
};
