import _ from 'lodash';
import chrome from 'ui/chrome';
import { parse, format } from 'url';

function getAppId(pathname) {
  const pathnameWithoutBasepath = pathname.slice(chrome.getBasePath().length);
  const match = pathnameWithoutBasepath.match(/^\/app\/([^\/]+)(?:\/|\?|#|$)/);
  if (match) return match[1];
}

function decodeKibanaUrl(url) {
  const parsedUrl = parse(url, true);
  const appId = getAppId(parsedUrl.pathname);
  const hash = parsedUrl.hash || '';
  const parsedHash = parse(hash.slice(1), true);

  return { parsedUrl, parsedHash };
}

export function replaceKibiStateInLastURLHelperFactory($location) {
  return function replaceKibiStateInLastURL(linkId) {
    // 1 get the _k from current url
    const _k = $location.search()._k;

    // 2 get last url for app
    const lastURL = chrome.getNavLinks().filter(link => link.id === linkId)[0];
    if (lastURL) {
      const { parsedUrl: parsedURL, parsedHash: parsedHash } = decodeKibanaUrl(lastURL.lastSubUrl);

      // 3 get the hash part and modify the _k
      const hash = _.clone(parsedHash);
      hash.query._k = _k;

      // 4 reconstruct the new url
      const modifiedLastURL = format({
        pathname: '/app/kibana',
        query: parsedURL.query,
        hash: format({
          pathname: hash.pathname,
          query: hash.query,
          hash: null
        })
      });

      // 5 store it in the local storage for app
      chrome.trackSubUrlForApp(linkId, modifiedLastURL);
    }
  };
}
