import { isEmpty } from 'lodash';

export function IndexPatternsExcludeIndicesProvider(config, createNotifier) {

  const OLD_EXCLUSION_FORMAT_RE = /[\[\]\{\}]/gi; // the old format was a stringified JSON array or map.
  const notify = createNotifier({ location: 'Exclude indices' });

  /**
   * Appends excluded indices to a list of indices.
   *
   * @param {Array} indices An array of index names.
   * @param {Boolean} flat If true, the method returns an array of index names,
   *               otherwise an array of objects with an index attribute that
   *               contains the index name.
   */
  function excludeIndices(indices, flat) {
    const excludedIndices = config.get('siren:excludedIndices');
    if (isEmpty(excludedIndices)) {
      return indices;
    }
    if (excludedIndices.match(OLD_EXCLUSION_FORMAT_RE)) {
      notify.warning(
        'The value specified in siren:excludedIndices must be a comma separated list of valid index names or patterns.' +
        ' You can fix it in Management -> Advanced Settings -> siren:excludedIndices'
      );
    }
    const resolved = [...indices];
    excludedIndices.split(',').forEach(e => {
      if (e.trim() !== '') {
        const index = `-${e}`;
        if (flat) {
          resolved.push(index);
        } else {
          resolved.push({
            index,
            min: -Infinity,
            max: Infinity
          });
        }
      }
    });

    return resolved;
  }

  return {
    excludeIndices
  };
};
