import { uiModules } from 'ui/modules';
import { EventsProvider } from 'ui/events';

uiModules.get('kibana')
  .service('sirenSession', (Private) => {
    const Events = Private(EventsProvider);

    class SirenSession extends Events {
      constructor() {
        super();
        this.data = {};
      }

      getData() {
        return this.data;
      }

      getDataString() {
        return JSON.stringify(this.data);
      }

      putData(data, initial) {
        if (data) {
          this.data = data;
        } else {
          this.data = {};
        }
        if (initial) {
          this.emit('kibisession:loaded');
        } else {
          this.emit('kibisession:changed');
        }
      }
    }

    return new SirenSession();
  });
