import _ from 'lodash';
import moment from 'moment';
import 'ui/field_format_editor/pattern/pattern';
import { IndexPatternsFieldFormatProvider } from 'ui/index_patterns/_field_format/field_format';
import { BoundToConfigObjProvider } from 'ui/bound_to_config_obj';
import dateTemplate from 'ui/stringify/editors/date.html';

export function stringifyDate(Private) {
  const FieldFormat = Private(IndexPatternsFieldFormatProvider);
  const BoundToConfigObj = Private(BoundToConfigObjProvider);


  _.class(DateTime).inherits(FieldFormat);
  function DateTime(params) {
    DateTime.Super.call(this, params);
  }

  DateTime.id = 'date';
  DateTime.title = 'Date';
  DateTime.fieldType = 'date';

  DateTime.paramDefaults = new BoundToConfigObj({
    pattern: '=dateFormat',
    timezone: '=dateFormat:tz'
  });

  DateTime.editor = {
    template: dateTemplate,
    controllerAs: 'cntrl',
    controller: function ($interval, $scope) {
      const self = this;
      self.sampleInputs = [
        Date.now(),
        +moment().startOf('year'),
        +moment().endOf('year')
      ];

      $scope.$on('$destroy', $interval(function () {
        self.sampleInputs[0] = Date.now();
      }, 1000));
    }
  };

  // kibi: mapping was added to make correct label for date fields with custom mapping
  DateTime.prototype._convert = function (val, mapping) {
    // don't give away our ref to converter so
    // we can hot-swap when config changes
    const pattern = this.param('pattern');
    const timezone = this.param('timezone');

    /* kibi: condition for taking saved values was removed for correct making of labels
       with same user input but different field's mapping */
    this._timeZone = timezone;
    this._memoizedPattern = pattern;

    this._memoizedConverter = _.memoize(function converter(val) {
      if (val === null || val === undefined) {
        return '-';
      }

      // kibi: added condition to correctly build label for fields with epoch_millis and custom mappings
      const FOUR_YEAR_PATTERN_LENGTH = 4;
      let date;
      if (typeof mapping === 'string') {
        const formats = mapping.split('||').map((rule) => {
          let ruleToReturn = rule;
          if (rule[0] === ' ') ruleToReturn = ruleToReturn.slice(1);
          if (rule.slice(-1) === ' ') ruleToReturn = ruleToReturn.slice(0, -1);
          return ruleToReturn;
        });

        // noSingleCodeRule - rule to understand if we have mapping with only year format in custom mappings
        // and prevent making label with epoch_millis formatting
        const noSingleCodeRule = ['yy', 'yyyy', 'YY', 'YYYY'].every(code => formats.indexOf(code) === -1);

        // millisRule1 and millisRule1 - rules to understand if field with support of epoch_millis
        const millisRule1 = formats.indexOf('epoch_millis') > 0
          && formats.length > 1
          && !isNaN(val)
          && noSingleCodeRule;
        const millisRule2 = formats.indexOf('epoch_millis') === 0
          && !isNaN(val);

        if (millisRule1 || millisRule2) {
          date = moment(parseInt(val));
          return date.isValid() ? date.format(pattern) : val;
        } else if (!noSingleCodeRule && !isNaN(val)) {
          if (formats.indexOf('epoch_millis') !== -1) {
            date = val.length === FOUR_YEAR_PATTERN_LENGTH ? moment(val) : moment(parseInt(val));
          } else {
            date = moment(val);
          }
          return date.isValid() ? date.format(pattern) : val;
        } else {
          // kibana doesn't understand very customed formats and can't format it by date.format() below
          // better to show in this case raw value
          return val;
        }
      } else {
        date = moment(val);
      };

      //if valid date AND (a number OR date object), format the date accordingly
      //toDateString here checks that the date portion of a Date object is in human readable form
      if (date.isValid() && (isNaN(val) || val.toDateString)) {
        return date.format(pattern);
        //Siren's validation 2nd condition can be just epoch_millis or year or infinity
        //and we can correclty format it
      } else if (!isNaN(val)) {
        if (val.length === FOUR_YEAR_PATTERN_LENGTH) {
          return moment((val)).format(pattern);
        } else {
          return date.isValid() ? moment(parseInt(val)).format(pattern) : val;
        };
      } else {
        //Otherwise return val as default
        return val;
      }
      // kibi: end
    });

    return this._memoizedConverter(val);
  };

  return DateTime;
}
