import { VisSchemasProvider } from './schemas';

export function VisVisTypeProvider(Private) {
  const VisTypeSchemas = Private(VisSchemasProvider);

  class VisType {
    constructor(opts) {
      opts = opts || {};

      this.name = opts.name;
      this.title = opts.title;
      this.responseConverter = opts.responseConverter;
      this.hierarchicalData = opts.hierarchicalData || false;
      this.icon = opts.icon;
      this.image = opts.image;
      this.description = opts.description;
      this.category = opts.category || VisType.CATEGORY.OTHER;
      this.isExperimental = opts.isExperimental;
      this.isBeta = opts.isBeta;
      this.schemas = opts.schemas || new VisTypeSchemas();
      this.params = opts.params || {};
      this.requiresSearch = opts.requiresSearch == null ? true : opts.requiresSearch; // Default to true unless otherwise specified
      this.requiresTimePicker = !!opts.requiresTimePicker;
      this.fullEditor = opts.fullEditor == null ? false : opts.fullEditor;
      this.implementsRenderComplete = opts.implementsRenderComplete || false;
      // kibi: Default to false unless otherwise specified
      // this is used for the spy panel of visualizations that query more than one index
      this.requiresMultiSearch = opts.requiresMultiSearch == null ? false : opts.requiresMultiSearch;
      // kibi: allow a visualization to retrieve results by itself
      this.delegateSearch = opts.delegateSearch == null ? false : opts.delegateSearch;
      // kibi: allow a visualization to hide the spy panel
      this.showSpyPanel = opts.showSpyPanel == null ? true : opts.showSpyPanel;
      // kibi: initialize a visualization based on the linked saved search
      this.init = opts.init;
      // kibi: visualization type versioning
      if (opts.version) {
        this.version = opts.version;
      }
      this.dashboard360Compatible = opts.dashboard360Compatible || false;
      this.disableCreation = opts.disableCreation || false;
      if (!this.params.optionTabs) {
        this.params.optionTabs = [
          { name: 'options', title: 'Options', editor: this.params.editor }
        ];
      }
    }

    createRenderbot() {
      throw new Error('not implemented');
    }
  }

  VisType.CATEGORY = {
    CHARTS: 'charts',
    TEXTUAL: 'textual',
    MAP: 'maps',
    INDIVIDUAL: 'individual',
    TIME: 'time',
    INTERACTIVE_FILTERS_RELATIONAL_NAVIGATION: 'interactive_filters_relational_navigation',
    OTHER: 'other'
  };

  return VisType;
}
