'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MappingsCollection = undefined;

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class MappingsCollection {
  // kibi: modified the class to use the v6 format

  // kibi: end
  constructor() {
    this.getCombined = () => {
      return this._currentMappings;
    };

    this.register = (newMappings, options = {}) => {
      Object.keys(this._currentMappings.doc.properties).forEach(key => {
        if (newMappings.hasOwnProperty(key)) {
          const pluginPartial = options.plugin ? `registered by plugin ${options.plugin} ` : '';
          throw new Error(`Mappings for ${key} ${pluginPartial}have already been defined`);
          return;
        }
      });
      Object.assign(this._currentMappings.doc.properties, newMappings);
    };

    this._defaultMappings = {
      doc: {
        properties: {
          type: {
            type: 'keyword'
          },
          updated_at: {
            type: 'date'
          },
          config: {
            properties: {
              buildNum: {
                type: 'keyword'
              }
            }
          },
          server: {
            properties: {
              uuid: {
                type: 'keyword'
              }
            }
          }
        }
      }
    };
    this._currentMappings = _lodash2.default.cloneDeep(this._defaultMappings);
  }

}

exports.MappingsCollection = MappingsCollection;
