import ngMock from 'ng_mock';
import expect from 'expect.js';
import { ConfigureOptionsProvider } from 'plugins/scatterplot_vis/helpers/configure_options_helper';

describe('configureOptions()', () => {
  let configureOptions;

  beforeEach(ngMock.module('kibana'));

  function init() {
    ngMock.inject(function (Private) {
      configureOptions = Private(ConfigureOptionsProvider);
    });
  };

  it('should correctly set options for different aggregation modes', () => {
    init();
    function updateForTestingWithCommonOptions(options) {
      if (options.aaBucket) {
        options.aaBucket.field = {
          type: 'fieldType'
        };
      };
      if (options.faBucket) {
        options.faBucket.field = {
          type: 'fieldType'
        };
      };
      options.aaXmetric = {
        name: 'aaXmetricName'
      };
      options.aaYmetric = {
        name: 'aaYmetricName'
      };
      options.faFilterX = 'faFilterXName';
      options.faFilterY = 'faFilterYName';
      options.stField = {
        type: 'stFieldType'
      };
    };

    const testOptions1 = {
      aggMode: 'Significant term data'
    };
    const testOptions2withDateHistogram = {
      aggMode: 'Filtered aggregator data',
      faBucket: {
        name: 'date_histogram'
      }
    };
    const testOptions2withHistogram = {
      aggMode: 'Filtered aggregator data',
      faBucket: {
        name: 'histogram'
      }
    };
    const testOptions2withTerms = {
      aggMode: 'Filtered aggregator data',
      faBucket: {
        name: 'terms'
      }
    };
    const testOptions2withSignificant = {
      aggMode: 'Filtered aggregator data',
      faBucket: {
        name: 'significant_terms'
      }
    };
    const testOptions3withDateHistogram = {
      aggMode: 'Any aggregator data',
      aaBucket: {
        name: 'date_histogram'
      }
    };
    const testOptions3withHistogram = {
      aggMode: 'Any aggregator data',
      aaBucket: {
        name: 'histogram'
      }
    };
    const testOptions3withTerms = {
      aggMode: 'Any aggregator data',
      aaBucket: {
        name: 'terms'
      }
    };
    const testOptions3withSignificant = {
      aggMode: 'Any aggregator data',
      aaBucket: {
        name: 'significant_terms'
      }
    };

    updateForTestingWithCommonOptions(testOptions1);
    configureOptions(testOptions1);
    expect(testOptions1.xFieldName).to.be('bg_count');
    expect(testOptions1.yFieldName).to.be('doc_count');
    expect(testOptions1.labelFieldName).to.be('key');
    expect(testOptions1.dotSizeFieldName).to.be('score');

    updateForTestingWithCommonOptions(testOptions2withDateHistogram);
    configureOptions(testOptions2withDateHistogram);
    expect(testOptions2withDateHistogram.xFieldName).to.be('faFilterXName');
    expect(testOptions2withDateHistogram.yFieldName).to.be('faFilterYName');
    expect(testOptions2withDateHistogram.labelFieldName).to.be('key_as_string');
    expect(testOptions2withDateHistogram.dotSizeFieldName).to.be('');

    updateForTestingWithCommonOptions(testOptions2withHistogram);
    configureOptions(testOptions2withHistogram);
    expect(testOptions2withHistogram.xFieldName).to.be('faFilterXName');
    expect(testOptions2withHistogram.yFieldName).to.be('faFilterYName');
    expect(testOptions2withHistogram.labelFieldName).to.be('key');
    expect(testOptions2withHistogram.dotSizeFieldName).to.be('');

    updateForTestingWithCommonOptions(testOptions2withTerms);
    configureOptions(testOptions2withTerms);
    expect(testOptions2withTerms.xFieldName).to.be('faFilterXName');
    expect(testOptions2withTerms.yFieldName).to.be('faFilterYName');
    expect(testOptions2withTerms.labelFieldName).to.be('key');
    expect(testOptions2withTerms.dotSizeFieldName).to.be('');

    updateForTestingWithCommonOptions(testOptions2withSignificant);
    configureOptions(testOptions2withSignificant);
    expect(testOptions2withSignificant.xFieldName).to.be('faFilterXName');
    expect(testOptions2withSignificant.yFieldName).to.be('faFilterYName');
    expect(testOptions2withSignificant.labelFieldName).to.be('key');
    expect(testOptions2withSignificant.dotSizeFieldName).to.be('');

    updateForTestingWithCommonOptions(testOptions3withDateHistogram);
    configureOptions(testOptions3withDateHistogram);
    expect(testOptions3withDateHistogram.xFieldName).to.be('aaXmetricName');
    expect(testOptions3withDateHistogram.yFieldName).to.be('aaYmetricName');
    expect(testOptions3withDateHistogram.labelFieldName).to.be('key_as_string');
    expect(testOptions3withDateHistogram.dotSizeFieldName).to.be('');

    updateForTestingWithCommonOptions(testOptions3withHistogram);
    configureOptions(testOptions3withHistogram);
    expect(testOptions3withHistogram.xFieldName).to.be('aaXmetricName');
    expect(testOptions3withHistogram.yFieldName).to.be('aaYmetricName');
    expect(testOptions3withHistogram.labelFieldName).to.be('key');
    expect(testOptions3withHistogram.dotSizeFieldName).to.be('');

    updateForTestingWithCommonOptions(testOptions3withTerms);
    configureOptions(testOptions3withTerms);
    expect(testOptions3withTerms.xFieldName).to.be('aaXmetricName');
    expect(testOptions3withTerms.yFieldName).to.be('aaYmetricName');
    expect(testOptions3withTerms.labelFieldName).to.be('key');
    expect(testOptions3withTerms.dotSizeFieldName).to.be('');

    updateForTestingWithCommonOptions(testOptions3withSignificant);
    configureOptions(testOptions3withSignificant);
    expect(testOptions3withSignificant.xFieldName).to.be('aaXmetricName');
    expect(testOptions3withSignificant.yFieldName).to.be('aaYmetricName');
    expect(testOptions3withSignificant.labelFieldName).to.be('key');
    expect(testOptions3withSignificant.dotSizeFieldName).to.be('');
  });
});