import _ from 'lodash';
import 'plugins/scatterplot_vis/directives/scatterplot_agg_selector';
import 'plugins/scatterplot_vis/directives/scatterplot_metric_selector';
import 'plugins/scatterplot_vis/scatterplot_vis_params.less';
import scatterPlotVisParamsTemplate from 'plugins/scatterplot_vis/scatterplot_vis_params.html';
import { uiModules } from 'ui/modules';

const module = uiModules.get('kibana/scatterplot_vis');

module.directive('scatterplotVisParams', function () {
  return {
    restrict: 'E',
    template: scatterPlotVisParamsTemplate,
    link: function ($scope) {

      if (!$scope.vis) return;

      const fields = _.sortBy($scope.vis.indexPattern.fields, 'name');

      $scope.listFields = fields.filter(function (f) {
        return f.filterable && !_.includes($scope.vis.indexPattern.metaFields, f.name)
          && (!_.endsWith(f.name, '.raw') || (_.endsWith(f.name, '.raw') && f.readFromDocValues))
          && (f.type === 'string' || f.type === 'number' || f.type === 'date' || f.type === 'boolean');
      });
      $scope.listFields.splice(0, 0, {
        name: '',
        displayName: ''
      });

      $scope.nonScriptedFields = $scope.listFields.filter(function (f) {
        return f.scripted === false;
      });

      $scope.listNumericFields = fields.filter(function (f) {
        return f.filterable === true && f.type === 'number';
      });
      $scope.listNumericFields.splice(0, 0, {
        name: '',
        displayName: ''
      });

      $scope.scales = ['linear', 'log', 'square root'];

      $scope.aggModes = ['Straight data', 'Significant term data', 'Any aggregator data', 'Filtered aggregator data'];

    }
  };
});
