'use strict';

var _lodash = require('lodash');

const licenseFormatCheck = function (server) {
  return {
    checkLicenseFormat: async () => {
      if ((0, _lodash.get)(server, 'plugins.siren_federate.federateClient')) {
        const license = await server.plugins.siren_federate.federateClient.getLicense();
        return ['license_content', 'license_validation'].every(k => k in license);
      }
    }
  };
};

module.exports = licenseFormatCheck;
