'use strict';

var _create_agent = require('./create_agent');

var _create_agent2 = _interopRequireDefault(_create_agent);

var _map_uri = require('./map_uri');

var _map_uri2 = _interopRequireDefault(_map_uri);

var _lodash = require('lodash');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function createProxy(server, method, path, config) {
  const proxies = new Map([['/elasticsearch', server.plugins.elasticsearch.getCluster('data')], ['/es_admin', server.plugins.elasticsearch.getCluster('admin')]]);

  const responseHandler = function (err, upstreamResponse, request, reply) {
    if (err) {
      reply(err);
      return;
    }

    if (upstreamResponse.headers.location) {
      // TODO: Workaround for #8705 until hapi has been updated to >= 15.0.0
      upstreamResponse.headers.location = encodeURI(upstreamResponse.headers.location);
    }

    reply(null, upstreamResponse);
  };

  for (const [proxyPrefix, cluster] of proxies) {
    const options = {
      method,
      path: createProxy.createPath(proxyPrefix, path),
      config: {
        timeout: {
          socket: cluster.getRequestTimeout()
        }
      },
      handler: {
        proxy: {
          // kibi: pass elasticsearch plugins
          mapUri: (0, _map_uri2.default)(cluster, proxyPrefix, server),
          // kibi: end
          agent: (0, _create_agent2.default)({
            url: cluster.getUrl(),
            ssl: cluster.getSsl()
          }),
          xforward: true,
          timeout: cluster.getRequestTimeout(),
          onResponse: responseHandler
        }
      }
    };

    (0, _lodash.assign)(options.config, config);

    server.route(options);
  }
}

createProxy.createPath = function createPath(prefix, path) {
  path = path[0] === '/' ? path : `/${path}`;
  prefix = prefix[0] === '/' ? prefix : `/${prefix}`;

  return `${prefix}${path}`;
};

module.exports = createProxy;
