import React from 'react';
import { mount } from 'enzyme';
import { FieldSelect } from './field_select';

test('renders', () => {
  const component = mount(<FieldSelect
    getIndexPattern={() => {return {};}}
    onChange={() => 0}
  />);
  expect(component.length).toBe(1); // eslint-disable-line
});

test('getIndexPattern called with correct parameters', () => {
  const indexPatternId = 'testId';
  const getIndexPatternMock = jest.fn(() => Promise.resolve({ // eslint-disable-line
    fields: [
      { name: 'field1' },
      { name: 'field2' },
      { name: 'field3' }
    ]
  }));
  const component = mount(<FieldSelect
    indexPatternId={indexPatternId}
    getIndexPattern={getIndexPatternMock}
    onChange={() => 0}
  />);
  expect(getIndexPatternMock.mock.calls.length).toBe(1); // eslint-disable-line
  expect(getIndexPatternMock.mock.calls[0].length).toBe(1); // eslint-disable-line
  expect(getIndexPatternMock.mock.calls[0][0]).toBe(indexPatternId); // eslint-disable-line
});
