import React from 'react';
import { mount } from 'enzyme';
import { IndexPatternSelect } from './index_pattern_select';
import indexPatternList from './test_data/index_pattern_list';

test('renders', () => {
  const component = mount(<IndexPatternSelect
    getIndexPatterns={() => Promise.resolve([])}
    onChange={() => 0}
  />);
  expect(component.length).toBe(1); // eslint-disable-line
});

test('getIndexPatterns called', () => {
  const getIndexPatternsMock = jest.fn(() => Promise.resolve(indexPatternList)); // eslint-disable-line
  const component = mount(<IndexPatternSelect
    getIndexPatterns={getIndexPatternsMock}
    onChange={() => 0}
  />);
  expect(getIndexPatternsMock.mock.calls.length).toBe(1); // eslint-disable-line
});
