// kibi: #5852 input control visualization from Kibana 6.2.4 - Start
import './vis.less';
import { VisVisTypeProvider } from 'ui/vis/vis_type';
import { TemplateVisTypeProvider } from 'ui/template_vis_type/template_vis_type';
import { VisTypesRegistryProvider } from 'ui/registry/vis_types';
import 'plugins/input_control_vis/wrapper/vis_angular_wrapper';
import 'plugins/input_control_vis/wrapper/editor/controls_tab';
import 'plugins/input_control_vis/wrapper/editor/options_tab';
import visTemplate from 'plugins/input_control_vis/wrapper/vis_wrapper_template.html';
import controlsTabTemplate from 'plugins/input_control_vis/wrapper/editor/controls_tab_template.html';
import optionsTabTemplate from 'plugins/input_control_vis/wrapper/editor/options_tab_template.html';
import image from './images/icon-input-control.svg';


function InputControlVisProvider(Private) {
  const VisType = Private(VisVisTypeProvider);
  const TemplateVisType = Private(TemplateVisTypeProvider);

  // return the visType object, which kibana will use to display and configure new Vis object of this type.
  return new TemplateVisType({
    name: 'input_control_vis',
    title: 'Controls',
    image,
    description: '[BETA] Create interactive controls for easy dashboard manipulation.',
    category: VisType.CATEGORY.INTERACTIVE_FILTERS_RELATIONAL_NAVIGATION,
    dashboard360Compatible: true,
    stage: 'lab',
    template: visTemplate,
    params: {
      defaults: {
        controls: [],
        updateFiltersOnChange: false,
        useTimeFilter: false,
      },
      editor: 'To bypass the bug.',
      optionTabs: [
        {
          name: 'options', // Replaced name to select it by default.
          title: 'Controls',
          editor: controlsTabTemplate
        },
        {
          name: 'controls',
          title: 'Options',
          editor: optionsTabTemplate
        }
      ]
    },
    requiresSearch: false
  });
}

// register the provider with the visTypes registry
VisTypesRegistryProvider.register(InputControlVisProvider);

// export the provider so that the visType can be required with Private()
export default InputControlVisProvider;
// kibi: #5852 input control visualization from Kibana 6.2.4 - End
