import { FilterBarQueryFilterProvider } from 'ui/filter_bar/query_filter';
import { SavedObjectsClientProvider } from 'ui/saved_objects';
import { SearchSourceProvider } from 'ui/courier/data_source/search_source';

class InjectAPI {
  constructor(Private, indexPatterns, timefilter) {
    this.queryFilter = Private(FilterBarQueryFilterProvider);
    this.savedObjectsClient = Private(SavedObjectsClientProvider);
    this.SearchSource = Private(SearchSourceProvider);
    this.indexPatterns = indexPatterns;
    this.timefilter = timefilter;
  }

  injectAPIs($scope) {
    $scope.vis.API = {
      savedObjectsClient: this.savedObjectsClient,
      SearchSource: this.SearchSource,
      indexPatterns: this.indexPatterns,
      queryFilter: this.queryFilter,
      timeFilter: this.timefilter
    };
  }
}

export { InjectAPI };