import 'plugins/kibana/discover/saved_index_pattern/_index_pattern';
import { uiModules } from 'ui/modules';
import { SavedObjectLoader } from 'ui/courier/saved_object/saved_object_loader';
import { savedObjectManagementRegistry } from 'plugins/kibana/management/saved_object_registry';

const module = uiModules.get('discover/saved_searches', [
  'kibana/notify'
]);

// Register this service with the saved object registry so it can be
// edited by the object editor.
savedObjectManagementRegistry.register({
  service: 'savedIndexPatterns',
  title: 'index patterns'
});

// kibi: added $http
module.service('savedIndexPatterns', function (Promise, kbnIndex, IndexPattern, Private, createNotifier, kbnUrl,
  $http) {
  const notify = createNotifier({
    location: 'Saved Index Pattern Service'
  });

  // kibi: added options
  const saveIndexPatternLoader = new SavedObjectLoader(IndexPattern, kbnIndex, kbnUrl, { $http });

  saveIndexPatternLoader.urlFor = function (id) {
    return kbnUrl.eval('#/management/siren/objects/savedIndexPatterns/{{id}}', { id: id });
  };
  return saveIndexPatternLoader;
});
