import 'plugins/kibana/discover/saved_relations/_saved_relation';
import 'ui/notify';
// kibi: import needed to prevent crash when plugins loaded
import 'ui/courier';
// kibi: end
import { uiModules } from 'ui/modules';
import { SavedObjectLoader } from 'ui/courier/saved_object/saved_object_loader';
import { CacheProvider } from 'ui/kibi/helpers/cache_helper';
import { savedObjectManagementRegistry } from 'plugins/kibana/management/saved_object_registry';

const module = uiModules.get('discover/saved_relations', [
  'kibana/notify'
]);

// Register this service with the saved object registry so it can be
// edited by the object editor.
savedObjectManagementRegistry.register({
  service: 'savedRelations',
  title: 'relations'
});

// kibi: added Private
module.service('savedRelations', function (kbnIndex, SavedRelation, kbnUrl, Private, $http) {
  const options = {
    caching: {
      find: true,
      get: true,
      scanAll: true,
      cache: Private(CacheProvider)
    },
    $http
  };
  const savedRelationLoader = new SavedObjectLoader(SavedRelation, kbnIndex, kbnUrl, options);
  // Customize loader properties since adding an 's' on type doesn't work for type 'relation' .
  savedRelationLoader.loaderProperties = {
    name: 'relations',
    noun: 'Saved Relation',
    nouns: 'saved relations'
  };
  savedRelationLoader.urlFor = function (id) {
    return kbnUrl.eval('#/management/siren/objects/savedRelations/{{id}}', { id: id });
  };

  return savedRelationLoader;
});
