import _ from 'lodash';
import angular from 'angular';
import { IndexPatternMissingIndices, NoAccessToFieldStats } from 'ui/errors';
import 'ui/directives/validate_index_name';
import 'ui/directives/auto_select_if_only_one';
// kibi: removed RefreshKibanaIndex as in Kibi refresh is done by saved object API
import uiRoutes from 'ui/routes';
import { uiModules } from 'ui/modules';
import { pickCreateButtonText } from './pick_create_button_text';
// kibi: imports
import { IndexPatternAuthorizationError } from 'ui/errors';
import { EntityType } from 'ui/kibi/components/ontology/entity_type';
import { FingerprintsProvider } from 'ui/kibi/quick_relations/fingerprints';
// kibi: imports end

uiRoutes
  .when('/management/siren/index/:indexPatternName?', {
  // kibi: redirect to new Data Model page
    redirectTo: '/management/siren/datamodel'
  });

uiModules.get('apps/management')
  .controller('managementIndicesCreate', function (
    $scope, $routeParams, kbnUrl, Private, Notifier, indexPatterns,
    es, config, Promise, $translate, confirmModal, savedSearches, dataModel,
    ontologyModel) {

    const fingerprints = Private(FingerprintsProvider);               //

    const notify = new Notifier({
      location: 'Indices create'
    });
    // kibi: removed RefreshKibanaIndex as in Investigate refresh is done by saved object API
    const intervals = indexPatterns.intervals;
    let loadingCount = 0;

    // Configure the new index pattern we're going to create.
    // kibi: removed expandWildcard, nameIsPattern and nameInterval as in Kibana 6.0.0
    this.formValues = {
      name: $routeParams.indexPattern || config.get('indexPattern:placeholder'),
      classLabel: $routeParams.indexPattern || config.get('indexPattern:placeholder'), // kibi: fill in the classLabel placeholder as well
      timeFieldOption: null,
      excludeIndices: false,
      calculateFingerprints: true,          // kibi: added fingerprints calculation
      // Default Value
      icon: 'fas fa-circle'
    };

    // UI state.
    this.timeFieldOptions = [];
    this.indexPatternError = null;
    // kibi: removed sampling as in Kibana 6.0.0

    this.isWildcard = indexPattern => indexPattern && indexPattern.includes('*');

    // kibi: removed resetIndex and updateSamples functions as in Kibana 6.0.0

    // kibi: removed canEnableExpandWildcard, isExpandWildcardEnabled, canUseTimePattern as in Kibana 6.0.0

    this.isLoading = () => loadingCount > 0;

    let activeRefreshTimeFieldOptionsCall;
    this.refreshTimeFieldOptions = () => {
    // if there is an active refreshTimeFieldOptions() call then we use their prevOption, allowing the previous
    // selection to persist across simultaneous calls to refreshTimeFieldOptions()
      const prevOption = activeRefreshTimeFieldOptionsCall ? activeRefreshTimeFieldOptionsCall.prevOption : this.formValues.timeFieldOption;

      // if there is an active refreshTimeFieldOptions() call then we use their prevOption, allowing the previous
      // selection to persist across simultaneous calls to refreshTimeFieldOptions()
      const thisCall = activeRefreshTimeFieldOptionsCall = { prevOption };

      ++loadingCount;
      this.timeFieldOptions = [];
      this.indexPatternError = null;
      this.formValues.timeFieldOption = null;
      indexPatterns.getTimeFieldOptions(this.formValues.name)
        .then(({ options, error }) => {
          if (thisCall !== activeRefreshTimeFieldOptionsCall) return;

          this.timeFieldOptions = options;
          this.indexPatternError = error;
          if (!this.timeFieldOptions) {
            return;
          }

          // Restore the previously selected state, or select the default option in the UI
          const previousFieldName = prevOption ? prevOption.fieldName : undefined;
          const restoredOption = previousFieldName ?
            this.timeFieldOptions.find(option => option.fieldName === previousFieldName) :
            undefined;
          const defaultOption = indexPatterns.pickDefaultTimeFieldOption(this.timeFieldOptions);
          this.formValues.timeFieldOption = restoredOption || defaultOption;
        })
        .catch(err => notify.error(err))
        .finally(() => {
          --loadingCount;
          if (thisCall === activeRefreshTimeFieldOptionsCall) {
            activeRefreshTimeFieldOptionsCall = null;
          }
          $scope.$apply();
        });
    };

    // kibi: added method
    this.changeClassLabel = () => {
      this.formValues.classLabel = this.formValues.name;
    };
    // kibi: end

    // kibi: removed constants nameIsPattern and nameInterval as in Kibana 6.0.0
    this.createIndexPattern = () => {
      const {
        name,
        timeFieldOption,
        excludeIndices, // kibi: added excludeIndices
        // kibi: added following new properties
        classLabel,
        shortDescription,
        longDescription,
        icon,
        color,
        calculateFingerprints
      } = this.formValues;

      const timeFieldName = timeFieldOption
        ? timeFieldOption.fieldName
        : undefined;

      // kibi: removed constants notExpandable and intervalName

      // kibi:
      // In our version we do not allow user to sepcify the id
      // instead we always generate a unique id
      // This was done to once for all decouple the id from the actual pattern everywhere
      const indexProperties = {
        name,
        timeFieldName,
        excludeIndices
      };

      const entity = {
        label: classLabel,
        icon,
        color,
        shortDescription,
        longDescription
      };

      loadingCount += 1;

      // kibi: removed RefreshKibanaIndex as in Investigate refresh is done by saved object API
      // kibi: do not try to set the default index pattern automatically
      // as user might not have permissions to do it

      // kibi: use dataModel service to create all objects
      return $scope.createSavedSearchModal(entity, indexProperties)
      // kibi: added fingerprints calculation to generate the 'primary key' and
      // 'single value' values automatically
        .then(id => id &&
      Promise.all([
        savedSearches.get(id),
        ontologyModel.getEntityMap().then(entityMap => entityMap[id])
      ])
        .then(([ ssearch, entity ]) => fingerprints
          .applyDefaultFieldMetadata(entity, ssearch)
          .then(() => calculateFingerprints && fingerprints.selectSavedSearches([ ssearch ])
            .then(fingerprints.calculate)
            .then(fps => fingerprints.applyToFieldMetadata(entity, ssearch, fps))))
        // Notify errors but not canceled operation, either way don't stop
        .catch(err => err && notify.error(err))
        .then(() => id))
      // kibi: end
        .then(id => {
          if (id) {
            kbnUrl.change(`/management/siren/datamodel/SAVED_SEARCH/${id}/`);
          }
        })
        .catch(err => {
          if (err instanceof IndexPatternMissingIndices) {
            return notify.error('Could not locate any indices matching that pattern. Please add the index to Elasticsearch');
          }

          notify.error(err);
        }).finally(() => {
          loadingCount -= 1;
        });
    };

    // kibi: if user confirm modal for creating saved search, run this function
    $scope.createSavedSearchModal = function (entity, indexProperties) {
    // Note:
    // Check if there is no another Index Pattern Search with exactly the same pattern
    // This limitation is temporary until graph browser support multiple index pattern searches based on the same pattern
      return dataModel.findIndexPatternSearchByPattern({ indexPropertiesName: indexProperties.name, silent: true })
        .then(searches => {
          if (searches.length > 0) {
            return new Promise(function (fulfill, reject) {
              const confirmModalOptions = {
                title: 'Index pattern search not created',
                confirmButtonText: 'OK',
                onConfirm: () => {
                  loadingCount -= 1;
                  fulfill();
                },
                messageAsHtml: 'true',
                noCancel: 'true'
              };
              confirmModal(
                `<p>Warning, There is already an index pattern search <b>${searches[0].label}</b><br/>
             based on the same indices (pattern: <b>${indexProperties.name}</b>).</p>
             <p>Please use it instead.</p>`,
                confirmModalOptions
              );
            });
          }

          return savedSearches.find()
            .then(savedSearchObjs => {
              const savedSearch = _.find(savedSearchObjs.hits, 'title', entity.label);
              if (savedSearch) {
                //there is a search with the same label already
                // show modal to warn the user
                return new Promise(function (fulfill, reject) {
                  const confirmModalOptions = {
                    confirmButtonText: 'Yes',
                    cancelButtonText: 'No',
                    onConfirm: () => {
                      dataModel.createIndexPatternSearch(entity, indexProperties)
                        .then(id => fulfill(id))
                        .catch(reject);
                    },
                    onCancel: () => {
                      loadingCount = 0;
                      fulfill(null);
                    },
                    messageAsHtml: 'true'
                  };
                  confirmModal(
                    `<p>Warning, a Search <b>${entity.label}</b> with the same name already exists.</p>
              <p>Do you want to create it?</p>`,
                    confirmModalOptions
                  );
                });
              } else {
                return dataModel.createIndexPatternSearch(entity, indexProperties);
              }
            });
        });
    };
    // kibi: end

    // kibi: removed watches on nameInterval, nameIsPattern and sampleCount as in Kibana 6.0.0
    $scope.$watch('controller.formValues.name', () => {
      if ($scope.controller.formValues.name) {
        this.refreshTimeFieldOptions();
      } else {
        this.indexPatternError = null;
        this.timeFieldOptions = [];
      }
    });

    $scope.$watchMulti([
      'controller.isLoading()',
      'form.name.$error.indexNameInput',
      'controller.formValues.timeFieldOption'
    ], ([loading, invalidIndexName, timeFieldOption]) => {
      const state = { loading, invalidIndexName, timeFieldOption };
      this.createButtonText = pickCreateButtonText($translate, state);
    });
  });
