import 'ui/field_editor';
import { IndexPatternsFieldProvider } from 'ui/index_patterns/_field';
import UrlProvider from 'ui/url';
import uiRoutes from 'ui/routes';
import template from './scripted_field_editor.html';
import './scripted_field_editor.less'; // kibi: added a less file

// kibi:
// changed
// '/management/kibana/indices/
// to
// /management/siren/datamodel/editIndexPatternField
//
uiRoutes
  .when('/management/siren/datamodel/editIndexPatternField/:searchEntityId/field/:fieldName*', { mode: 'edit' })
  .when('/management/siren/datamodel/editIndexPatternField/:searchEntityId/create-field/', { mode: 'create' })
  .defaults(/management\/siren\/datamodel\/editIndexPatternField\/[^\/]+\/(field|create-field)(\/|$)/, {
    template,
    mapBreadcrumbs($route, breadcrumbs) {
      const { entity } = $route.current.locals;
      return breadcrumbs.map(crumb => {
        if (crumb.id !== entity.id) {
          return crumb;
        }

        return {
          ...crumb,
          display: entity.label
        };
      });
    },
    resolve: {
      entity: function ($route, ontologyModel, courier) {
        return ontologyModel.getEntityMap()
          .then(entityMap => {
            return entityMap[$route.current.params.searchEntityId];
          })
          .catch(courier.redirectWhenMissing('/management/siren/datamodel'));
      },
      indexPattern: function ($route, ontologyModel, courier) {
        return ontologyModel.getEntityMap()
          .then(entityMap => {
            const entity = entityMap[$route.current.params.searchEntityId];
            return courier.indexPatterns.get(entity.indexPattern);
          })
          .catch(courier.redirectWhenMissing('/management/siren/datamodel'));
      }
    },
    controllerAs: 'fieldSettings',
    controller: function FieldEditorPageController($route, Private, createNotifier, docTitle) {
      const Field = Private(IndexPatternsFieldProvider);
      const notify = createNotifier({ location: 'Field Editor' });
      const kbnUrl = Private(UrlProvider);

      this.mode = $route.current.mode;
      this.indexPattern = $route.current.locals.indexPattern;
      this.entity = $route.current.locals.entity;


      if (this.mode === 'edit') {
        const fieldName = $route.current.params.fieldName;
        this.field = this.indexPattern.fields.byName[fieldName];

        if (!this.field) {
          notify.error(this.indexPattern + ' does not have a "' + fieldName + '" field.');
          kbnUrl.redirectToRoute(this.indexPattern, 'edit');
          return;
        }

      }
      else if (this.mode === 'create') {
        this.field = new Field(this.indexPattern, {
          scripted: true,
          type: 'number'
        });
      }
      else {
        throw new Error('unknown fieldSettings mode ' + this.mode);
      }

      docTitle.change([this.field.name || 'New Scripted Field', this.indexPattern.title]);
      this.goBack = function () {
      // TODO:
      // try to come back to the one from which we came
      // this would require to change the url to pass the searchID instead of indexPatternId
      // kibi: changed
        kbnUrl.change('management/siren/datamodel');
      };
    }
  });
