import _ from 'lodash';
import { toEditableConfig } from 'plugins/kibana/management/sections/settings/lib/to_editable_config';
import 'plugins/kibana/management/sections/settings/advanced_row';
import { management } from 'ui/management';
import uiRoutes from 'ui/routes';
import { uiModules } from 'ui/modules';
import indexTemplate from 'plugins/kibana/management/sections/settings/index.html';
// kibi: import
import 'ui/kibi/directives/kibi_select_dashboard';

uiRoutes
// kibi: reoute is changed
  .when('/management/siren/settings', {
    template: indexTemplate
  });

uiModules.get('apps/management')
  .directive('kbnManagementAdvanced', function (config, savedDashboards) {
    return {
      restrict: 'E',
      link: function ($scope) {
      // react to changes of the config values
        config.watchAll(changed, $scope);

        // initial config setup
        changed();

        function changed() {
          const all = config.getAll();
          const editable = _(all)
            .map((def, name) => toEditableConfig({
              def,
              name,
              value: def.userValue,
              isCustom: config.isCustom(name)
            }))
            .value();
          const writable = _.reject(editable, 'readonly');
          // kibi: added to show title for the selected dashboard
          const dashboardSetting = _.find(writable, setting => setting.name === 'siren:defaultDashboardId');
          savedDashboards.find().then((cachedDashboards) => {
            const selectedDashboard = _.find(cachedDashboards.hits, dash => dash.id === dashboardSetting.value);
            dashboardSetting.valueTitle = selectedDashboard.title;
          });
          // kibi: end
          $scope.configs = writable;
        }
      }
    };
  });

// kibi: url is changed
management.getSection('kibana').register('settings', {
  display: 'Advanced Settings',
  order: 20,
  url: '#/management/siren/settings'
});
