import 'plugins/kibana/visualize/saved_visualizations/_saved_vis';
import { VisTypesRegistryProvider } from 'ui/registry/vis_types';
import { uiModules } from 'ui/modules';
import { CacheProvider } from 'ui/kibi/helpers/cache_helper';
import { SavedObjectLoader } from 'ui/courier/saved_object/saved_object_loader';
import { savedObjectManagementRegistry } from 'plugins/kibana/management/saved_object_registry';

const app = uiModules.get('app/visualize');

// Register this service with the saved object registry so it can be
// edited by the object editor.
savedObjectManagementRegistry.register({
  service: 'savedVisualizations',
  title: 'visualizations'
});

// kibi: added $http
app.service('savedVisualizations', function (Promise, kbnIndex, SavedVis, Private, createNotifier, kbnUrl,
  $http) {
  const visTypes = Private(VisTypesRegistryProvider);
  const notify = createNotifier({
    location: 'Saved Visualization Service'
  });

  const options = {
    caching: {
      find: true,
      get: false, // Multi-Chart relies on this bug
      scanAll: true,
      cache: Private(CacheProvider)
    },
    $http
  };

  // kibi: added options
  const saveVisualizationLoader = new SavedObjectLoader(SavedVis, kbnIndex, kbnUrl, options);
  saveVisualizationLoader.mapHits = function (hit) {
    let typeName;
    if (hit.visState) {
      try { typeName = JSON.parse(hit.visState).type; }
      catch (e) { /* missing typename handled below */ } // eslint-disable-line no-empty
    }

    if (!typeName || !visTypes.byName[typeName]) {
      if (!typeName) notify.error('Visualization type is missing. Please add a type to this visualization.', hit);
      else notify.error('Visualization type of "' + typeName + '" is invalid. Please change to a valid type.', hit);
      return kbnUrl.redirect('/management/siren/objects/savedVisualizations/{{id}}', { id: hit.id });
    }

    hit.type = visTypes.byName[typeName];
    hit.icon = hit.type.icon;
    return hit;
  };

  saveVisualizationLoader.urlFor = function (id) {
    return kbnUrl.eval('#/visualize/edit/{{id}}', { id: id });
  };
  return saveVisualizationLoader;
});
