'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerValueSuggestions = registerValueSuggestions;

var _handle_es_error = require('../../../lib/handle_es_error');

var _handle_es_error2 = _interopRequireDefault(_handle_es_error);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function registerValueSuggestions(server) {
  server.route({
    path: '/api/kibana/suggestions/values/{index}',
    method: ['POST'],
    handler: function (req, reply) {
      const { index } = req.params;
      const { field, query } = req.payload;

      const { callWithRequest } = server.plugins.elasticsearch.getCluster('data');
      const include = query ? `.*${query}.*` : undefined;
      const body = getBody({
        field,
        include,
        shard_size: 10,
        size: 10
      });

      return callWithRequest(req, 'search', { index, body }).then(res => {
        const suggestions = res.aggregations.suggestions.buckets.map(bucket => bucket.key);
        return reply(suggestions);
      }).catch(error => reply((0, _handle_es_error2.default)(error)));
    }
  });
}

function getBody(terms) {
  return {
    aggs: {
      suggestions: { terms }
    }
  };
}
