import React from 'react';
import { shallow } from 'enzyme';
import HorizontalLegend from './horizontal_legend';
import legendProps from './test_data/legend_props';

test('horizontal legend renders', () => {
  legendProps.legendPosition = 'bottom';
  const component = shallow(<HorizontalLegend
    {...legendProps}
  />);
  expect(component).toMatchSnapshot(); // eslint-disable-line
});

test('Click works.', () => {
  legendProps.legendPosition = 'bottom';
  legendProps.onClick = jest.fn(); // eslint-disable-line
  const component = shallow(<HorizontalLegend
    {...legendProps}
  />);
  component.find('[className="fa fa-chevron-down"]').hostNodes().simulate('click');
  expect(legendProps.onClick.mock.calls.length).toBe(1); // eslint-disable-line
});

test('onToggle works.', () => {
  legendProps.legendPosition = 'bottom';
  legendProps.onToggle = jest.fn(); // eslint-disable-line
  const component = shallow(<HorizontalLegend
    {...legendProps}
  />);
  component.find('[className="rhythm_chart__legend_item"]').hostNodes().simulate('click');
  expect(legendProps.onToggle.mock.calls.length).toBe(1); // eslint-disable-line
});