import React from 'react';
import { shallow } from 'enzyme';
import VerticalLegend from './vertical_legend';
import legendProps from './test_data/legend_props';

test('legend renders: right', () => {
  legendProps.legendPosition = 'right';
  const component = shallow(<VerticalLegend
    {...legendProps}
  />);
  expect(component).toMatchSnapshot(); // eslint-disable-line
});

test('legend renders: left', () => {
  legendProps.legendPosition = 'left';
  const component = shallow(<VerticalLegend
    {...legendProps}
  />);
  expect(component).toMatchSnapshot(); // eslint-disable-line
});

test('Click works.', () => {
  legendProps.legendPosition = 'left';
  legendProps.onClick = jest.fn(); // eslint-disable-line
  const component = shallow(<VerticalLegend
    {...legendProps}
  />);
  component.find('[className="fa fa-chevron-left"]').hostNodes().simulate('click');
  expect(legendProps.onClick.mock.calls.length).toBe(1); // eslint-disable-line
});

test('onToggle works.', () => {
  legendProps.legendPosition = 'left';
  legendProps.onToggle = jest.fn(); // eslint-disable-line
  const component = shallow(<VerticalLegend
    {...legendProps}
  />);
  component.find('[className="rhythm_chart__legend_item"]').hostNodes().simulate('click');
  expect(legendProps.onToggle.mock.calls.length).toBe(1); // eslint-disable-line
});