import { uiModules } from  'ui/modules';
import chrome from 'ui/chrome';

const app = chrome.getApp();
const appId = app && app.id;

// Only inject decorator on kibana app
if (appId === 'kibana') {

  uiModules
    .get('kibana')
    .config(($provide) => {

      $provide.decorator('kbnAggTableDirective', ($delegate) => {
      // Original
        const originalController = $delegate[0].controller;

        // Customize formatted columns
        $delegate[0].controller = function ($scope) {
          originalController.call(this, $scope);
          $scope.$watch('formattedColumns', function () {
            if ($scope.table && $scope.formattedColumns) {
              for (let i = 0; i < $scope.formattedColumns.length; i++) {
                $scope.formattedColumns[i].titleAlignmentClass = $scope.table.columns[i].titleAlignmentClass;
                $scope.formattedColumns[i].totalAlignmentClass = $scope.table.columns[i].totalAlignmentClass;
              }
              if ($scope.table.totalLabel && $scope.formattedColumns.length && !$scope.formattedColumns[0].total) {
                $scope.formattedColumns[0].total = $scope.table.totalLabel;
              }
            }
          });
        };

        return $delegate;
      });

      $provide.decorator('paginatedTableDirective', ($delegate) => {
      // Original
        const originalTemplate = $delegate[0].template;

        // Inject template
        $delegate[0].template = originalTemplate
          .replace('{{ col.class }}', '{{ col.class }} {{ col.titleAlignmentClass }}')
          .replace('numeric-value', 'numeric-value {{ col.totalAlignmentClass }}');

        return $delegate;
      });

    });
}