'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _joi = require('joi');

var _joi2 = _interopRequireDefault(_joi);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// siren: Configuration for the timelion-sheet saved object.
const TimelionSheetConfiguration = {
  type: 'timelion-sheet',
  title: 'Timelion Sheet',
  schema: _joi2.default.object().keys({
    title: _joi2.default.string(),
    hits: _joi2.default.number().integer(),
    description: _joi2.default.string().default(null),
    timelion_sheet: _joi2.default.string(),
    timelion_interval: _joi2.default.string(),
    timelion_other_interval: _joi2.default.string(),
    timelion_chart_height: _joi2.default.number().integer(),
    timelion_columns: _joi2.default.number().integer(),
    timelion_rows: _joi2.default.number().integer(),
    version: _joi2.default.number().integer(),
    kibanaSavedObjectMeta: _joi2.default.object().keys({
      searchSourceJSON: _joi2.default.string()
    })
  })

};

exports.default = TimelionSheetConfiguration;
module.exports = exports['default'];
