'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Ip = undefined;

var _field_format = require('./field_format');

class Ip extends _field_format.FieldFormat {
  constructor(params) {
    super(params);
  }

  _convert(val) {
    if (val === undefined || val === null) return '-';
    if (!isFinite(val)) return val;

    // shazzam!
    return [val >>> 24, val >>> 16 & 0xFF, val >>> 8 & 0xFF, val & 0xFF].join('.');
  }
}

exports.Ip = Ip;
Ip.id = 'ip';
Ip.title = 'IP Address';
Ip.fieldType = 'ip';
