'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.percentProvider = percentProvider;

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _numeral = require('./_numeral');

var _fetch_config_defaults = require('./fetch_config_defaults');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function percentProvider(config) {
  const fetchDefaults = param => (0, _fetch_config_defaults.fetchConfigDefaults)(param, config);
  const Numeral = (0, _numeral.numeralProvider)(config);
  function percentage() {
    return Numeral.factory({
      id: 'percent',
      title: 'Percentage',
      paramDefaults: fetchDefaults({
        pattern: '=format:percent:defaultPattern',
        fractional: true
      }),
      sampleInputs: [0.10, 0.99999, 1, 100, 1000],
      prototype: {
        _convert: _lodash2.default.compose(Numeral.prototype._convert, function (val) {
          return this.param('fractional') ? val : val / 100;
        })
      }
    });
  }

  return percentage();
}
