'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Source = undefined;

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _no_white_space = require('../helpers/no_white_space');

var _field_format = require('./field_format');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const sourceHtml = `<dl class="source truncate-by-height">
<% defPairs.forEach(function (def) { %>
  <dt><%- def[0] %>:</dt>
  <dd><%= def[1] %></dd>
  <%= ' ' %>
<% }); %>
</dl>`;
const template = _lodash2.default.template((0, _no_white_space.noWhiteSpace)(sourceHtml));

class Source extends _field_format.FieldFormat {
  constructor(params) {
    super(params);
  }
}

exports.Source = Source;
Source.id = '_source';
Source.title = '_source';
Source.fieldType = '_source';
Source.prototype._convert = {
  text: JSON.stringify,
  html: function (source, field, hit) {
    // kibi: removed field and hit from getConverterFor('text')()
    if (!field) return this.getConverterFor('text')(source);
    // kibi: end

    const highlights = hit && hit.highlight || {};
    const formatted = field.indexPattern.formatHit(hit);
    const highlightPairs = [];
    const sourcePairs = [];

    _lodash2.default.keys(formatted).forEach(function (key) {
      const pairs = highlights[key] ? highlightPairs : sourcePairs;
      const field = _lodash2.default.shortenDottedString(key);
      const val = formatted[key];
      pairs.push([field, val]);
    }, []);

    return template({ defPairs: highlightPairs.concat(sourcePairs) });
  }
};
