'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Truncate = undefined;

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _field_format = require('./field_format');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const omission = '...';

class Truncate extends _field_format.FieldFormat {
  constructor(params) {
    super(params);
  }

  _convert(val) {
    const length = this.param('fieldLength');
    if (length > 0) {
      return _lodash2.default.trunc(val, {
        'length': length + omission.length,
        'omission': omission
      });
    }

    return val;
  }
}

exports.Truncate = Truncate;
Truncate.id = 'truncate';
Truncate.title = 'Truncated String';
Truncate.fieldType = ['string'];
